<?php if(count($brands) > 0): ?>

    <!-- testimonial-section end -->

    <section class="testimonial-section centred">

        <div class="container inner-container">

            <div class="sec-title">

                <h5><?php echo e($configration->app_name); ?></h5>

                <h2><?php echo e(trans('home.Our developers')); ?></h2>

            </div>

            <div class="region row">

                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="col-sm-12 col-md-4 col-lg-3">

                        <a href="<?php echo e(LaravelLocalization::localizeUrl('developer/'.$brand->link_en.'/projects')); ?>">

                            <div class="card">

                                <div class="card-img">

                                    <div class="img-div lazy-div">

                                        <img class="lazy" data-src="<?php echo e(Helper::uploadedImagesPath('brands',$brand->logo)); ?>" data-srcset="<?php echo e(Helper::uploadedImagesPath('brands',$brand->logo)); ?>"alt="Developer Logo">

                                        <div class="next-lazy-img"></div>

                                    </div>

                                </div>

                                <div class="card-body">

                                    <h5><?php echo e((app()->getLocale() == 'en')?$brand->name_en:$brand->name_ar); ?></h5>

                                    <span><?php echo e($brand->projectsCount()); ?></span>

                                </div>

                            </div>

                        </a>

                    </div>



                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

            <div class="more-btn centred"><a href="<?php echo e(LaravelLocalization::localizeUrl('developers')); ?>" class="theme-btn btn-one"><?php echo e(trans('home.View All Listing')); ?></a></div>

        </div> 

    </section>

    <!-- testimonial-section end -->

<?php endif; ?><?php /**PATH C:\OSPanel\domains\haliem_company_profile\resources\views/website/home-partials/brands.blade.php ENDPATH**/ ?>