<!--====================Site Footer==============-->
<footer class="full-row bg-footer text-light pb-0">
    <div class="container">
        <div class="row row-cols-lg-3 row-cols-1 gy-5 xxs-link-single">
            <div class="col-lg-3 text-center">
                <div class="footer-widget">
                    <div class="footer-logo mb-4">
                        <a href="{{ LaravelLocalization::localizeUrl('/') }}"><img src="{{ url('uploads/settings/source/' , $configration->footer_logo) }}" alt="Image not found!"></a>
                    </div>
                </div>
                <div class="footer-widget">
                    <div class="transparent-social-media-1 list-color-light justify-content-center hover-list-color-primary hyperlink-mr-20">
                        @if($setting->facebook)
                        <a href="{{ $setting->facebook }}"><i class="fab fa-facebook-f"></i></a>
                        @endif
                        @if($setting->twitter)
                        <a href="{{ $setting->twitter }}"><i class="fab fa-twitter"></i></a>
                        @endif
                        @if($setting->linkedin)
                        <a href="{{ $setting->linkedin }}"><i class="fab fa-linkedin-in"></i></a>
                        @endif
                        @if($setting->youtube)
                        <a href="{{ $setting->youtube }}"><i class="fab fa-youtube"></i></a>
                        @endif
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="footer-widget widget-link-double">
                    <h4 class="widget-title text-white mb-4">{{ trans('home.quick_links') }}</h4>
                    <ul class="links-footer">
                        @foreach ($menus as $footerMenu)
                        @php
                        $subMenus = method_exists($footerMenu, 'subMenu') ? $footerMenu->subMenu() : [];
                        @endphp

                        @if ($footerMenu->type != 'services' && count($subMenus) == 0)
                        <li>
                            <a href="{{ LaravelLocalization::LocalizeUrl($footerMenu->type == 'home' ? '/' : $footerMenu->type) }}">
                                <span class="text">{{ $footerMenu->{'name_' . $lang} }}</span>
                            </a>
                        </li>
                        @endif
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="footer-widget widget-link-double">
                    <h4 class="widget-title text-white mb-4">{{ trans('home.services') }}</h4>
                    <ul class="links-footer">
                        @foreach($menuServices as $footerService)
                        <li><a href="{{ LaravelLocalization::localizeUrl('service/' .$footerService->{'link_' .$lang}) }}"><span class="text">{{ $footerService->{'name_' .$lang} }}</span></a></li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="footer-widget widget-newsletter">
                    <h4 class="widget-title text-white mb-4">{{ trans('home.contactinfo') }}</h4>
                    <ul class="links-footer">
                        <li class="contact-footer"><a href="mailto:{{ $setting->email }}"><i class="fas fa-envelope"></i> {{ $setting->email }}</a></li>
                        @foreach($phones as $phone)
                        <li class="contact-footer"><a href="tel:{{ $phone->code }}{{ $phone->phone }}"><i class="fas fa-phone-alt"></i> {{ $phone->phone }}</a></li>
                        @endforeach
                        @foreach($addresses as $address)
                        <li class="contact-footer"><a href="{{ $address->link }}" target="_blank"><i class="fas fa-map-marker-alt"></i> {{ $address->{'address_' .$lang} }}</a></li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="full-row fs-13 py-4">
        <div class="container">
            <div class="row">
                <div class="col">
                    <div class="d-flex flex-wrap justify-content-center align-items-center">
                        <span class="copyright-text text-white">{!! $setting->copyright !!}</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!--====================Footer==============-->