<!--=============== Heder ============= -->
<header id="header" class="nav-on-top">
    <div class="main-nav header-sticky  py-3 d-none d-lg-block">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <nav class="navbar navbar-expand-lg navbar-light nav-dark nav-primary-hover nav-primary-active">
                        <a class="navbar-brand" href="{{ LaravelLocalization::localizeUrl('/') }}"><img class="nav-logo" src="{{ url('uploads/settings/source/' , $configration->app_logo) }}" alt="Patron"></a>
                        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#main-navbar-content" aria-controls="main-navbar-content" aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <div class="collapse navbar-collapse" id="main-navbar-content">
                            <ul class="navbar-nav justify-content-end">
                                @foreach ($menus as $menu)
                                @php
                                $subMenus = method_exists($menu, 'subMenu') ? $menu->subMenu() : [];
                                $hasSubMenu = count($subMenus) > 0;
                                $isServices = ($menu->type == 'services' && isset($menuServices) && count($menuServices) > 0);
                                @endphp
                                @if ($isServices || $hasSubMenu)
                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle" href="#">{{ $menu->{'name_' .$lang} }}</a>
                                    <ul class="dropdown-menu">
                                        @if ($isServices)
                                        @foreach ($menuServices as $child_service)
                                        <li class="nav-item dropdown"><a class="dropdown-item" href="{{ LaravelLocalization::localizeUrl('service/' .$child_service->{'link_' .$lang}) }}">{{ $child_service->{'name_' .$lang} }}</a>
                                            @if (!empty($child_service->childs) && count($child_service->childs) > 0)
                                            <ul class="dropdown-menu">
                                                @foreach($child_service->childs as $menuservChiled)
                                                <li><a class="dropdown-item" href="{{ LaravelLocalization::localizeUrl('service/' .$menuservChiled->{'link_' .$lang}) }}">{{ $menuservChiled->{'name_' .$lang} }}</a></li>
                                                @endforeach
                                            </ul>
                                            @endif
                                        </li>
                                        @endforeach
                                        @endif
                                        @if ($hasSubMenu)
                                        @foreach ($subMenus as $subMenu)
                                        <li class="nav-item dropdown"><a class="dropdown-item" href="{{LaravelLocalization::localizeUrl($subMenu->type ?? '#') }}">{{ $subMenu->{'name_' . $lang} }}</a>
                                        </li>
                                        @endforeach
                                        @endif
                                    </ul>
                                </li>
                                @else
                                <li class="nav-item">
                                    <a class="nav-link" href="{{LaravelLocalization::localizeUrl(!empty($menu->type) ? ($menu->type == 'home' ? '/' : $menu->type) : '#') }}">{{ $menu->{'name_' .$lang} }}</a>
                                </li>
                                @endif
                                @endforeach
                                @foreach (LaravelLocalization::getSupportedLocales() as $localeCode => $properties)
                                @if (
                                ($localeCode == 'ar' && LaravelLocalization::getCurrentLocale() == 'en') ||
                                ($localeCode == 'en' && LaravelLocalization::getCurrentLocale() == 'ar'))
                                <li class="nav-item">
                                    <a class="nav-link" href="{{ LaravelLocalization::getLocalizedURL($localeCode, null, [], true) }}">{{ trans("home.$localeCode") }}</a>
                                </li>
                                @endif
                                @endforeach
                            </ul>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    <!--===== Mobile-Nav ==== -->
    @include('layouts.partials.mobile-nav')
    <!--===== Mobile-Nav ==== -->
</header>
<!--=============== Heder ============= -->