<!doctype html>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>
    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <!-- Page Title -->
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Favicon Icon -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(url('uploads/settings/source/' . $configration->fav_icon)); ?>">
    <!-- Google Fonts Css-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('slicknav.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper-bundle.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('all.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('custom.css')); ?>" />

    
</head>

<body>

        
        
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="page-content">
        <?php echo $__env->yieldContent('content'); ?>
        </div>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('layouts.partials.social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        



    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('validator.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.slicknav.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.counterup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('isotope.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('SmoothScroll.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('parallaxie.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gsap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('SplitText.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('ScrollTrigger.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.mb.YTPlayer.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('function.js')); ?>"></script>

    <script>
        Fancybox.bind("[data-fancybox]", {
            // Your custom options
        });
    </script>

    <?php echo $__env->yieldContent('script'); ?>

    <!--Design By Youssef & Dev By Ahmed Essam-->

</body>

</html>
<?php /**PATH C:\OSPanel\domains\artbuild\resources\views/layouts/app.blade.php ENDPATH**/ ?>