<!doctype html>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>

    <!-- Meta -->
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="ThemeServices">
    <?php echo $__env->yieldContent('title'); ?>
    <!-- favicons Icons -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=El+Messiri:wght@400..700&family=IBM+Plex+Sans+Arabic:wght@100;200;300;400;500;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.css" />
    <!--=============== FavIcon  ===============-->
    <link rel="icon" href="<?php echo e(url('uploads/settings/source/', $configration->fav_icon)); ?>">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('fontawesome.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('odometer.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('slick.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />

    
</head>

<body>
    
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <div id="travol-main">
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('layouts.partials.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    
    



    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery-3.6.0.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.slick.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('odometer.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@4.0/dist/fancybox.umd.js"></script>
    <script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery')); ?>"></script>
    <script>
        Fancybox.bind("[data-fancybox]", {
            infinite: true,
            startIndex: 0   
        });
    </script>

    <?php echo $__env->yieldContent('script'); ?>

    <!--Design & Dev By Ahmed Essam-->

</body>

</html>
<?php /**PATH C:\OSPanel\domains\shahin\resources\views/layouts/app.blade.php ENDPATH**/ ?>