<!doctype html>
<html lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>

<head>
    <!-- Meta -->
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!-- Page Title -->
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Favicon Icon --><!-- favicons Icons -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(url('uploads/settings/source/' , $configration->fav_icon)); ?>" />
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(url('uploads/settings/source/' , $configration->fav_icon)); ?>" />
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(url('uploads/settings/source/' , $configration->fav_icon)); ?>" />
    <link rel="manifest" href="<?php echo e(url('uploads/settings/source/' , $configration->fav_icon)); ?>" />
    <!-- Google Fonts Css-->
    <link
        href="https://fonts.googleapis.com/css2?family=Alexandria:wght@100..900&family=Cairo:wght@200..1000&display=swap"
        rel="stylesheet">
    <link
        href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('custom-animate.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('font-awesome-all.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('jarallax.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('jquery.magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('flaticon.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.carousel.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.theme.default.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('nice-select.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('jquery-ui.css')); ?>" />
    <!-- template styles -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>" />
    
</head>

<body class="custom-cursor">

    <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.mobile-nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts.partials.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <!-- JS here -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jarallax.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.ajaxchimp.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.appear.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wNumb.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('isotope.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery-ui.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('marquee.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('countdown.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gsap/gsap.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gsap/ScrollTrigger.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gsap/SplitText.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('script.js')); ?>"></script>
    <!-- template js -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js"></script>

    <script>
        Fancybox.bind("[data-fancybox]", {
            // Your custom options
        });
    </script>

    <?php echo $__env->yieldContent('script'); ?>

    <!--Design & Dev By Ahmed Essam-->

</body>

</html>
<?php /**PATH C:\OSPanel\domains\mansour\resources\views/layouts/app.blade.php ENDPATH**/ ?>