<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.add_projects')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.projects')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/projects')); ?>"><?php echo e(trans('home.projects')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.add_projects')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php echo Form::open(['route' => 'projects.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <div class="row">

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                        <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                        <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>">
                                    </div>

                                    <div class="col-md-8 mb-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="image">
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="alt_img"> <?php echo e(trans('home.alt_img')); ?></label>
                                        <input class="form-control" name="alt_img" type="text" placeholder="<?php echo e(trans('home.alt_img')); ?>">
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label for="helperText"><?php echo e(trans('home.category')); ?></label>
                                        <select class="form-control choices-single-default" data-trigger name="category_id" required>
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>"><?php echo e((app()->getLocale() == 'en')?$category->name_en:$category->name_ar); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save_and_continue')); ?></button>
                                    <a href="<?php echo e(url('/admin/projects')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                <!-- End Row -->
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\elegancia\resources\views/admin/projects/addProject.blade.php ENDPATH**/ ?>