@extends('layouts.admin')
<title>{{trans('home.home_sliders')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.home_sliders')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.home_sliders')}}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="{{url('admin/home-sliders/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>

        </div>
        <!-- End Page Header -->

        @if(session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.home_sliders')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th>{{trans('home.id')}}</th>
                                    <th class="wd-20p">{{trans('home.title')}}</th>
                                    <th class="wd-20p">{{trans('home.link')}}</th>
                                    <th class="wd-20p">{{trans('home.lang')}}</th>
                                    <th class="wd-15p">{{trans('home.status')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($sliders as $slider)
                                    <tr id="{{$slider->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$slider->id}}"/></td>
                                        <td><a href="{{ route('home-sliders.edit', $slider->id) }}">{{$slider->id}}</a></td>
                                        <td><a href="{{ route('home-sliders.edit', $slider->id) }}">{{$slider->title}}</a></td>
                                        <td><a href="{{ route('home-sliders.edit', $slider->id) }}">{{$slider->link}}</a></td>
                                        <td><a href="{{ route('home-sliders.edit', $slider->id) }}">{{trans("home.$slider->lang")}}</a></td>
                                        <td>
                                            <a href="{{ route('home-sliders.edit', $slider->id) }}">
                                                @if($slider->image)
                                                    <img src="{{url('/uploads/sliders/home-sliders/resize200')}}/{{$slider->image}}" width="70">
                                                @else
                                                    <img src="{{url('resources/assets/back/img/noimage.png')}}" width="70">
                                                @endif
                                            </a>
                                        </td>
                                        <td><a href="{{ route('home-sliders.edit', $slider->id) }}">@if($slider->status == 1) {{trans('home.yes')}} @else  {{trans('home.no')}} @endif</a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                </div>

                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection

@section('script')
<script>
//// btn_delete ////
$(document).ready(function(){
    $('#btn_delete').click(function(){

        var id = [];
        <?php
        $last_word = Request::segment(3);
        Session::put('route', $last_word);
        ?>
        $('.tableChecked:checked').each(function(i){
            id[i] = $(this).val();
        });
        if(id.length === 0) //tell you if the array is empty
        {
            alert("Please Select atleast one checkbox");
        }
        else
        {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"<?php echo Session::get('route')?>/"+ id,
                type:'DELETE',
                data:{id:id},
                success:function()
                {
                    for(var i=0; i<id.length; i++)
                    {
                        $('tr#'+id[i]+'').css('background-color', '#ccc');
                        $('tr#'+id[i]+'').fadeOut('slow');
                        $('input:checkbox').removeAttr('checked');
                    }
                }
            });
        }


    });
});

//// btn_active ////
$(document).ready(function(){
    $('#btn_active').click(function(){
        var id = [];
        <?php
        $last_word = Request::segment(3);
        Session::put('route', $last_word);
        ?>
        $('.tableChecked:checked').each(function(i){
            id[i] = $(this).val();
        });
        console.log(id);
        if(id.length === 0) //tell you if the array is empty
        {
            alert("Please Select atleast one checkbox");
        }
        else
        {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"<?php echo Session::get('route')?>/up/"+ id,
                method:'POST',
                data:{id:id},
                success:function()
                {
                    $('input:checkbox').removeAttr('checked');
                    location.reload();
                }
            });
        }
    });

    $('#btn_back').click(function(){

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url:"backup",
            method:'GET',
            success:function()
            {

            }
        });

    });

});
</script>
@endsection
