<!doctype html>
<html lang="{{ LaravelLocalization::getCurrentLocale() }}" dir="{{LaravelLocalization::getCurrentLocale() == 'ar' ? 'rtl' : 'ltr' }}">

<head>
    <meta charset="utf-8">


    <meta http-equiv="x-ua-compatible" content="ie=edge" />
    <meta name="description" content="" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta property="og:title" content="" />
    <meta property="og:type" content="" />
    <meta property="og:url" content="" />
    <meta property="og:image" content="" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @yield('meta')
    @include('layouts.partials.hreflang')

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon"
        href="{{ url('uploads/settings/source/' . $configration->fav_icon) }}" />
    <!-- Template CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('swiper-bundle.css') }}">
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('plugins/animate.min.css') }}" />
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('main.css?v=5.6') }}" />

@if(LaravelLocalization::getCurrentLocale() == 'ar')
    <link rel="stylesheet" href="{{ Helper::cssFilesPath('rtl.css') }}" />
 @endif
   <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@500&display=swap" rel="stylesheet">

    @yield('style')
    <!-- Google Tag Manager -->
    {!! $setting->publish_gtm_script ? html_entity_decode($setting->gtm_script) : '' !!}
    <!-- End Google Tag Manager -->
</head>

<body>

   @include('layouts.partials.header')
   @include('layouts.partials.mobile')
   <main class="main">
      @yield('content')
   </main>

   
@include('layouts.partials.footer')

 <!-- Preloader Start -->
 <div id="preloader-active">
   <div class="preloader d-flex align-items-center justify-content-center">
     <div class="preloader-inner position-relative">
       <div class="loadingio-spinner-ripple-nq4q5u6dq7r">
           <div class="ldio-x2uulkbinbj">
               <div></div>
               <div></div>
           </div>
       </div>
     </div>
   </div>
 </div>

 <ul id="wrapper" class="" style="transform: translate(15%, 100%);">
   <li class="Icon call ">
       <!--<span class="tooltip">Call</span>-->
       <a href="tel:+2{{ $setting->mobile }}">
           <span>
           <!--<i class="fa fa-phone"></i>-->
           <img src="{{url('resources/assets/front/images/icons/smartphone-call.png')}}" alt="hotline" />
         </span></a>
   </li>
   <li class="Icon whatsapp">
       <!--<span class="tooltip">whatsapp</span>-->
       <a href="https://wa.me/+2{{ $setting->whatsapp }}" target="_blank"><span><i class="fab fa-whatsapp"></i></span></a>
   </li>

</ul>


    <script src="{{ Helper::jsFilesPath('vendor/modernizr-3.6.0.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/jquery-3.6.0.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/jquery-migrate-3.3.0.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('vendor/bootstrap.bundle.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/slick.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/jquery.syotimer.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/waypoints.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/wow.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/perfect-scrollbar.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/magnific-popup.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/select2.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/counterup.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/jquery.countdown.min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/images-loaded.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/isotope.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/scrollup.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('swiper.min.js')}}"></script>
  
    <script src="{{ Helper::jsFilesPath('plugins/jquery.vticker-min.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/jquery.theia.sticky.js')}}"></script>
    <script src="{{ Helper::jsFilesPath('plugins/jquery.elevatezoom.js')}}"></script>
    <!-- Template  JS -->
    <script src="{{ Helper::jsFilesPath('main.js?v=5.6')}}"></script>


    @yield('script')

    <!-- Google Tag Manager -->
    {!! $setting->publish_gtm_script ? html_entity_decode($setting->gtm_noscript) : '' !!}
    <!-- End Google Tag Manager -->
</body>

</html>
