@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
    @php echo $schema @endphp
@endsection

@section('content')
    <!-- Header Banner -->
    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url({{ url('uploads/aboutStrucs/source/' . $about->banner) }});"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="{{ laravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                <li>/</li>
                <li><span>{{ $blog->{'title_' . $lang} }}</span></li>
            </ul>
            <h2>{{ $blog->{'title_' . $lang} }}</h2>
        </div>
    </section>
    <!--End  Header Banner -->


    <div class="page-content mb-50">
        <div class="container">
            <div class="row flex-row-reverse">
                <div class="col-lg-8">
                    <div class="single-page pt-50 pl-30">

                        <figure class="single-thumbnail">
                            <img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}" alt="">
                        </figure>
                        <div class="single-header style-2">
                            <h2 class="mb-10">{{ $blog->{'title_' . $lang} }}</h2>
                        </div>
                        <div class="single-content">
                            <p>{!! Str::words($blog->{'text_' . $lang}, 40, '...') !!}</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 primary-sidebar sticky-sidebar pt-50">
                    <div class="widget-area">
                        <!-- Product sidebar Widget -->
                        <div class="sidebar-widget product-sidebar mb-50 p-30 bg-grey border-radius-10">
                            <h5 class="section-title style-1 mb-30">{{ trans('home.related_blogs') }}</h5>
                            @foreach ($blogs as $blogItem)
                                @if ($blogItem->id != $blog->id)
                                    <div class="single-post clearfix">
                                        <div class="image">
                                            <img src="{{ Helper::uploadedImagesPath('blogitems', $blogItem->image) }}"
                                                alt="#" />
                                        </div>
                                        <div class="content pt-10">
                                            <h5><a
                                                    href="{{ laravelLocalization::LocalizeUrl('blog/' . $blogItem->{'link_' . $lang}) }}">{{ $blogItem->{'title_' . $lang} }}</a>
                                            </h5>


                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <!--Tags-->
                        <h5 class="section-title style-1 mb-30">{{ trans('home.ContactWithUs') }}</h5>
                        @if (session()->has('contact_message'))
                            <div class="messages text-success">
                                {{ session()->get('contact_message') }}
                            </div>
                        @endif
                        <form class="contact-form-style mt-30"
                            action="{{ LaravelLocalization::localizeUrl('save/contact-us') }}" method="post">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">

                                        <input type="text" name="name" value="{{ old('name') }}"
                                            placeholder="{{ trans('home.name') }}" required>
                                        @error('name')
                                            <div class="help-block with-errors">*{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">


                                        <input type="text" name="email" class="form-control" id="email"
                                            value="{{ old('email') }}" placeholder="{{ trans('home.email') }}" required>
                                        @error('email')
                                            <div class="help-block with-errors">*{{ $message }}</div>
                                        @enderror

                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="phone" id="phone"
                                            value="{{ old('phone') }}" placeholder="{{ trans('home.phone') }}" required>
                                        @error('phone')
                                            <div class="help-block with-errors"> *{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">

                                        <textarea name="message" id="message" rows="3" placeholder="{{ trans('home.message') }}">{{ old('message') }}</textarea>
                                        @error('message')
                                            <div class="help-block with-errors"></div>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group mg_top apbtn">
                                        <button class="theme_btn" type="submit">{{ trans('home.Submit Now') }}</button>
                                    </div>
                                </div>
                            </div>
                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
