@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
@endsection

@section('content')
    <!-- Header Banner -->

    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url({{ url('uploads/settings/source/' . $configration->product_banner) }});"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="{{ LaravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                <li>/</li>
                <li><span> {{ trans('home.products') }}</span></li>
            </ul>
            <h2> {{ trans('home.products') }}</h2>
        </div>
    </section>





    <section class="section-padding py-100">
        <div class="container">
            <div class="row">
                <div class="col-md-3">
                    <div class="sidebar-widget widget-category-2 mb-30">
                        <h5 class="section-title style-1 mb-30">{{ trans('home.categories') }}</h5>
                        <ul>
                            @foreach ($mainCategories as $mainCategory)
                            <li>
                                <a href='{{ LaravelLocalization::localizeUrl('category/' . $mainCategory->{'link_' . $lang} . '/products') }}'>{{ $mainCategory->{'name_'.$lang} }}</a><span class="count">{{ $mainCategory->projects()->count() }}</span>
                            </li>
                            @endforeach

                        </ul>
                    </div>
                    <!-- Fillter By Price -->
                
                    <Form action="{{ laravelLocalization::LocalizeUrl('products') }}" method="GET"> 
                        <div class="sidebar-widget price_range range mb-30">
                            <h5 class="section-title style-1 mb-30">Fill by Products</h5>
                            <div class="list-group">
                                <div class="list-group-item mb-10 mt-10">
                                    @foreach ($categoryAttributes as $index => $categoryAttribute)
                                        <label class="fw-900">{{ $categoryAttribute->{'name_' . $lang} }}</label>
                                        @foreach ($categoryAttribute->values() as $key => $categoryAttributeValue)
                                            <div class="custome-checkbox">
                                                <div>
                                                    <input class="form-check-input" type="checkbox"
                                                        name="categoryAttributeValue[{{ $categoryAttribute->id }}][]"
                                                        id="exampleCheckbox{{ $key + 1 .'-'.$index+1}}"
                                                        value="{{ $categoryAttributeValue->id }}"
                                                        {{ in_array($categoryAttributeValue->id, request()->input("categoryAttributeValue.{$categoryAttribute->id}", [])) ? 'checked' : '' }} />
                                                    <label class="form-check-label"
                                                        for="exampleCheckbox{{ $key + 1 .'-'.$index+1}}"><span>{{ $categoryAttributeValue->{'value_' . $lang} }}</span></label>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endforeach
                                </div>
                            </div>
                            <button class='btn btn-sm btn-default' type="submit">
                                <i class="fi-rs-filter mr-5"></i> Fillter
                            </button>
                        </div>
                </Form>
                    <!-- Product sidebar Widget -->

                </div>
           
                <div class="col-md-9">
                    @if(count($projects)>0)
                    <div class="infinite-scroll">
                        <div class="row">
                            <!--start product Wrap-->
                            @foreach ($projects as $key => $product)
                                <div class="col-md-3">
                                    <div class="product-cart-wrap">
                                        <div class="product-img-action-wrap">
                                            <div class="product-img product-img-zoom">
                                                <a
                                                    href="{{ laravelLocalization::LocalizeUrl('product/' . $product->{'link_' . $lang}) }}">
                                                    <img class="default-img"
                                                        src="{{ Helper::uploadedImagesPath('projects', $product->image) }}"
                                                        alt="" />
                                                </a>
                                            </div>
                                        </div>
                                        <div class="product-content-wrap">

                                            <h2><a
                                                    href="{{ laravelLocalization::LocalizeUrl('product/' . $product->{'link_' . $lang}) }}">{{ $product->{'name_' . $lang} }}</a>
                                            </h2>

                                            <div class="sold mt-15 mb-15">

                                                <p class="text-heading"> {!! Str::limit($product->{'text_' . $lang}, 5, '...') !!}</p>
                                            </div>

                                            <a href="{{ laravelLocalization::LocalizeUrl('product/' . $product->{'link_' . $lang}) }}"
                                                class="btn w-100 hover-up"><i
                                                    class="fi-rs-eye mr-5"></i>{{ trans('home.read_more') }}</a>
                                        </div>
                                    </div>
                                </div>
                                <!--End product Wrap-->
                            @endforeach
                            {{ $projects->links() }}
                        </div>
                    </div>
                    @else
                    <div class="alert alert-warning text-center mt-5" role="alert">
                        No Products found
                   </div>
                @endif
                </div>

              
            </div>
        </div>
    </section>

    <!--End Products Section ======================-->
@endsection


@section('script')
    <!-- js for scroll pagination -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jscroll/2.4.1/jquery.jscroll.min.js"></script>
    <script>
        $(document).ready(function() {
            $('nav[aria-label="Pagination Navigation"]').hide();
            // Initialize jscroll
            var jscrollInstance = $('.infinite-scroll').jscroll({
                autoTrigger: true,
                loadingMsg: '<div class="loading"><b>Loading...</b></div>',
                padding: 0,
                nextSelector: 'nav[aria-label="Pagination Navigation"] a[rel="next"]',
                contentSelector: 'div.infinite-scroll',
                callback: function() {
                    // Remove pagination navigation after appending new content
                    $('nav[aria-label="Pagination Navigation"]').remove();

                    // Check if there are more pages
                    if ($('nav[aria-label="Pagination Navigation"] a[rel="next"]').length === 0) {
                        // No more pages, destroy jscroll
                        jscrollInstance.destroy();
                    }
                }
            });
        });
    </script>
@endsection
