@extends('layouts.app')

@section('content')
 <!-- Header Banner -->
    <section class="page-header">
        <div class="page-header__bg"
            style="background-image: url({{ url('uploads/settings/source/' . $configration->category_banner) }});"></div>
        <div class="container">
            <ul class="thm-breadcrumb list-unstyled">
                <li><a href="{{ LaravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                <li>/</li>
                <li><span>{{ $category->{'name_' . $lang} }}</span></li>
            </ul>
            <h2>{{ $category->{'name_' . $lang} }}</h2>
       </div>
     </section>
     <section class="section-padding py-100">
        <div class="container">
            <div class="text-center pt-5 mb-30">
                {!! $category->{'desc_' . $lang} !!}
            </div>
            <div class="row">
               
                <div class="col-md-12">
                    <div class="infinite-scroll">
                        @if(count($categories)>0)
                        <div class="row">
                              <!--Start product Wrap-->
                            @foreach ($categories as $category)
                           
                                <div class="col-md-3">
                                    <div class="product-cart-wrap">
                                        <div class="product-img product-img-zoom">
                                                <a
                                                    href="{{ laravelLocalization::LocalizeUrl('category/' . $category->{'link_' . $lang}.'/products') }}">
                                                    <img class="default-img"
                                                        src="{{ Helper::uploadedImagesPath('categories', $category->image) }}"
                                                        alt="" />
                                                </a>
                                            </div>
                                        <div class="product-content-wrap">

                                            <h2><a
                                                    href="{{ LaravelLocalization::localizeUrl('category/' . $category->{'link_'.$lang}.'/products') }}">{{ $category->{'name_' . $lang} }}</a>
                                            </h2>

                                            <!--<div class="sold mt-15 mb-15">-->

                                            <!--    <p class="text-heading">{!! Str::words($category->{'desc_' . $lang}, 40, '...') !!}</p>-->
                                            <!--</div>-->

                                            <a href="{{ LaravelLocalization::localizeUrl('category/' . $category->{'link_'.$lang}.'/products') }}"
                                                class="btn w-100 hover-up"><i
                                                    class="fi-rs-eye mr-5"></i>{{ trans('home.show Details') }}</a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                          
                            <!--End product Wrap-->
                        </div>
                        @else

                        <div class="alert alert-warning text-center mt-5" role="alert">
                           No categorys found
                          </div>

                        @endif
                       
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection