<title><?php echo e(trans('home.home_sliders')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.home_sliders')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.home_sliders')); ?></li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="<?php echo e(url('admin/home-sliders/create')); ?>"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> <?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> <?php echo e(trans('home.delete')); ?></button></a>
            </div>

        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.home_sliders')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.title')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.link')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.lang')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($slider->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($slider->id); ?>"/></td>
                                        <td><a href="<?php echo e(route('home-sliders.edit', $slider->id)); ?>"><?php echo e($slider->id); ?></a></td>
                                        <td><a href="<?php echo e(route('home-sliders.edit', $slider->id)); ?>"><?php echo e($slider->title); ?></a></td>
                                        <td><a href="<?php echo e(route('home-sliders.edit', $slider->id)); ?>"><?php echo e($slider->link); ?></a></td>
                                        <td><a href="<?php echo e(route('home-sliders.edit', $slider->id)); ?>"><?php echo e(trans("home.$slider->lang")); ?></a></td>
                                        <td>
                                            <a href="<?php echo e(route('home-sliders.edit', $slider->id)); ?>">
                                                <?php if($slider->image): ?>
                                                    <img src="<?php echo e(url('/uploads/sliders/home-sliders/resize200')); ?>/<?php echo e($slider->image); ?>" width="70">
                                                <?php else: ?>
                                                    <img src="<?php echo e(url('resources/assets/back/img/noimage.png')); ?>" width="70">
                                                <?php endif; ?>
                                            </a>
                                        </td>
                                        <td><a href="<?php echo e(route('home-sliders.edit', $slider->id)); ?>"><?php if($slider->status == 1): ?> <?php echo e(trans('home.yes')); ?> <?php else: ?>  <?php echo e(trans('home.no')); ?> <?php endif; ?></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
					</div>
                </div>

                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
//// btn_delete ////
$(document).ready(function(){
    $('#btn_delete').click(function(){

        var id = [];
        <?php
        $last_word = Request::segment(3);
        Session::put('route', $last_word);
        ?>
        $('.tableChecked:checked').each(function(i){
            id[i] = $(this).val();
        });
        if(id.length === 0) //tell you if the array is empty
        {
            alert("Please Select atleast one checkbox");
        }
        else
        {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"<?php echo Session::get('route')?>/"+ id,
                type:'DELETE',
                data:{id:id},
                success:function()
                {
                    for(var i=0; i<id.length; i++)
                    {
                        $('tr#'+id[i]+'').css('background-color', '#ccc');
                        $('tr#'+id[i]+'').fadeOut('slow');
                        $('input:checkbox').removeAttr('checked');
                    }
                }
            });
        }


    });
});

//// btn_active ////
$(document).ready(function(){
    $('#btn_active').click(function(){
        var id = [];
        <?php
        $last_word = Request::segment(3);
        Session::put('route', $last_word);
        ?>
        $('.tableChecked:checked').each(function(i){
            id[i] = $(this).val();
        });
        console.log(id);
        if(id.length === 0) //tell you if the array is empty
        {
            alert("Please Select atleast one checkbox");
        }
        else
        {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url:"<?php echo Session::get('route')?>/up/"+ id,
                method:'POST',
                data:{id:id},
                success:function()
                {
                    $('input:checkbox').removeAttr('checked');
                    location.reload();
                }
            });
        }
    });

    $('#btn_back').click(function(){

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url:"backup",
            method:'GET',
            success:function()
            {

            }
        });

    });

});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/opera/resources/views/admin/sliders/home-sliders/sliders.blade.php ENDPATH**/ ?>