<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_career')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.careers')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/careers')); ?>"><?php echo e(trans('home.careers')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_career')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_career')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/careers/'.$career->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.title_en')); ?></label>
                                    <input class="form-control" name="title_en" type="text" placeholder="<?php echo e(trans('home.title_en')); ?>"  value="<?php echo e($career->title_en); ?>" required>
                                </div>

                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.title_ar')); ?></label>
                                    <input class="form-control" name="title_ar" type="text" placeholder="<?php echo e(trans('home.title_ar')); ?>" value="<?php echo e($career->title_ar); ?>" required>
                                </div>

                                <div class="col-md-4">
                                    <label><?php echo e(trans('home.image')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <?php if($career->image): ?>
                                    <div class="col-md-12">
                                        <img src="<?php echo e(url('\uploads\careers\resize200')); ?>\<?php echo e($career->image); ?>" width="150">
                                    </div>
                                <?php endif; ?>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.desc_en')); ?></label>
                                    <textarea class="form-control area1" name="desc_en" type="text" placeholder="<?php echo e(trans('home.desc_en')); ?>"><?php echo e($career->desc_en); ?></textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.desc_ar')); ?></label>
                                    <textarea class="form-control area1" name="desc_ar" type="text" placeholder="<?php echo e(trans('home.desc_ar')); ?>"><?php echo e($career->desc_ar); ?></textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.responsibilities_en')); ?></label>
                                    <textarea class="form-control area1" name="responsibilities_en" type="text" placeholder="<?php echo e(trans('home.responsibilities_en')); ?>"><?php echo e($career->responsibilities_en); ?></textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.responsibilities_ar')); ?></label>
                                    <textarea class="form-control area1" name="responsibilities_ar" type="text" placeholder="<?php echo e(trans('home.responsibilities_ar')); ?>"><?php echo e($career->responsibilities_ar); ?></textarea>
                                </div>

                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" <?php echo e(($career->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/careers')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\opera\resources\views/admin/careers/editCareer.blade.php ENDPATH**/ ?>