

<?php $__env->startSection('content'); ?>

<section class="page-header">

    <div class="page-header__bg" style="background-image: url(<?php echo e(url('uploads/aboutStrucs/source/' . $about->banner)); ?>);"></div>

        <div class="container">

            <ul class="thm-breadcrumb list-unstyled">

                <li><a href="<?php echo e(laravelLocalization::LocalizeUrl('/')); ?>"><?php echo e(trans('home.home')); ?></a></li>

                <li>/</li>

                <li><span><?php echo e(trans('home.Branches')); ?></span></li>

            </ul>

            <h2><?php echo e(trans('home.Branches')); ?></h2>

        </div>

</section>

<!--End page-header-->

<section class="contact-section pt-100 pb-100">

            <div class="container">

             

            <div class="row">

                      <div class="col-md-12 text-center pb-50">

                        <p class="content-box"><?php echo $configration->feature_section_desc; ?></p>

                    </div>

                    <div class="col-md-12">

                        <div class="top-select pb-50">

                            <div class="row">

                                <div class="form-group col-md-6">

                                    <select class="form-control region select2 filter" name="region_id">

                                           <option><?php echo e(trans('home.regions')); ?></option>

                                           <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                  <option value="<?php echo e($region->id); ?>"  data-gis="<?php echo e($region->gis); ?>"><?php echo e($region->{'name_'.$lang}); ?></option>

                                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                         

                                         

                                    </select>

                                </div>

                                <div class="form-group col-md-6">

                                    <select class="form-control area select2 filter" >

                                        <option>Branches</option>

                                    </select>

                                </div>

                            </div>     

                        </div>

                    </div>

             </div>

            <div class="row">

                        <div class="row" id="gis-branches">

                            <!-- GIS branches will be dynamically added here -->

                        </div>

                    </div>

            

            </div>

           

        </section>

<?php $__env->stopSection(); ?>



<?php $__env->startSection('script'); ?>



<script>

    $(document).ready(function() {

        // Handle region selection change

        $('.region').change(function() {

            var region_id = $(this).val();

           

            // Update the GIS branches

            $.ajaxSetup({

                        headers: {

                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

                        }

                    });



            $.ajax({

                url: "<?php echo e(LaravelLocalization::localizeUrl('get-Branches')); ?>",

                method: 'POST',

                data:{

                    region_id:region_id

                },

                success: function(data) {

                    var lang = "<?php echo e(\LaravelLocalization::getCurrentLocale()); ?>";

                    // Clear previous branches

                     $('#gis-branches').empty();



                    // Add new branches

                    $.each(data['RegionAreas'], function(index, branch) {

                        var branchHtml = '<div class="col-md-4">' +

                            '<div class="branche branche-page">' +

                            '<a href="' + branch.map_url + '" class="btn btn-dark btn-rounded" target="_blank">View Location</a>' +

                            '<span><i class="w-icon-map-marker"></i>' + branch['name_'+lang] + '</span>' +

                            '<p>' + branch['address_' + lang] + '</p>' +

                            '<span><a href="tel:' + branch.mobile + '"><i class="w-icon-call"></i>' + branch.mobile + '</a></span>' +

                            '</div>' +

                            '</div>';



                        $('#gis-branches').append(branchHtml);

                    });

                },

                error: function(xhr, status, error) {

                    

                }

            });

        });

    });

</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\opera\resources\views/website/Branches.blade.php ENDPATH**/ ?>