<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_region')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.regions')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/regions')); ?>"><?php echo e(trans('home.regions')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_region')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    <?php echo Form::open(['method'=>'PATCH','url' => 'admin/regions/'.$region->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.edit_region')); ?></h6>
                        <hr>
                    </div>
                    <div class="row">

                        <div class="form-group col-md-4">
                            <label class=""><?php echo e(trans('home.name_en')); ?></label>
                            <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>"  value="<?php echo e($region->name_en); ?>" required>
                        </div>

                        <div class="form-group col-md-4">
                            <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                            <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($region->name_ar); ?>" >
                        </div>
                        <div class="form-group col-md-2">
                            <label class=""><?php echo e(trans('home.order')); ?></label>
                            <input class="form-control" name="order" type="number" placeholder="<?php echo e(trans('home.order')); ?>" value="<?php echo e($region->order); ?>" >
                        </div>

                        <div class="form-group col-md-2">
                            <label for="parent"><?php echo e(trans('home.country')); ?></label>
                            <select class="form-control select2" name="country_id">
                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($country->id); ?>" <?php echo e(($country->id == $region->country_id)?'selected':''); ?>><?php echo e((app()->getLocale()=='en')? $country->name_en:$country->name_ar); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                            </select>
                        </div>

                        <div class="form-group col-md-6">
                            <label class="ckbox">
                                <input name="status" value="1" <?php echo e(($region->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                            </label>
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label class="ckbox">
                                <input name="available_units" value="1" <?php echo e(($region->available_units == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.available_units')); ?></span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

     <!-- Row-->
     <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div class="row">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                            <a href="<?php echo e(url('/admin/regions')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <?php echo Form::close(); ?>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/opera/resources/views/admin/regions/editRegion.blade.php ENDPATH**/ ?>