<title><?php echo e(trans('home.add_home_sliders')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.home_sliders')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/home-sliders')); ?>"><?php echo e(trans('home.home_sliders')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_slider')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->
    <?php echo Form::open(['route' => 'home-sliders.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.add_slider')); ?></h6>
                            <hr>
                        </div>
                        <div class="row">

                            <div class="form-group col-md-4">
                                <label class=""><?php echo e(trans('home.title')); ?></label>
                                <input class="form-control" name="title" type="text" placeholder="<?php echo e(trans('home.title')); ?>" value="<?php echo e(old('title')); ?>">
                            </div>
                            <div class="form-group col-md-4">
                                <label class=""><?php echo e(trans('home.title2')); ?></label>
                                <input class="form-control" name="title2" type="text" placeholder="<?php echo e(trans('home.title2')); ?>" value="<?php echo e(old('title2')); ?>">
                            </div>

                            <div class="col-md-4">
                                <label><?php echo e(trans('home.image')); ?></label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-5">
                                <label class=""><?php echo e(trans('home.link')); ?></label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">http://www.google.com</span>
                                    </div>
                                    <input type="text" class="form-control" name="link" placeholder="<?php echo e(trans('home.link')); ?>" >
                                </div> 
                            </div>

                            <div class="form-group col-md-5">
                                <label for="helperText"><?php echo e(trans('home.lang')); ?></label>
                                <select class="form-control select2" name="lang" required>
                                    <option value="en"><?php echo e(trans('home.english')); ?></option>
                                    <option value="ar"><?php echo e(trans('home.arabic')); ?></option>
                                </select>
                            </div>

                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.order')); ?></label>
                                <input class="form-control" name="order" type="number" min="0" autocomplete="off" placeholder="<?php echo e(trans('home.order')); ?>">
                            </div>

                            <div class="form-group col-md-12">
                                <label class=""><?php echo e(trans('home.text')); ?></label>
                                <textarea class="form-control" name="text"  placeholder="<?php echo e(trans('home.text')); ?>"></textarea>
                            </div>                            

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="status" value="1" type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

       <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/home-sliders')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <!-- End Row -->
    <?php echo Form::close(); ?>


</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\opera\resources\views/admin/sliders/home-sliders/addSlider.blade.php ENDPATH**/ ?>