<title><?php echo e(trans("home.edit_user")); ?></title>
<?php $__env->startSection('content'); ?>

    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.users')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/roles')); ?>"><?php echo e(trans('home.users')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_user')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_user')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/users/'.$user->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label for="helperText"><?php echo e(trans('home.f_name')); ?></label>
                                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.f_name')); ?>" value="<?php echo e($user->f_name); ?>" name="f_name"  required>
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label for="helperText"><?php echo e(trans('home.l_name')); ?></label>
                                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.l_name')); ?>" value="<?php echo e($user->l_name); ?>" name="l_name"  required>
                                </div>

                                <div class="form-group col-md-3">
                                        <label for="helperText"><?php echo e(trans('home.email')); ?></label>
                                        <input type="email" class="form-control email" placeholder="<?php echo e(trans('home.email')); ?>" value="<?php echo e($user->email); ?>" name="email"  required>
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="helperText"><?php echo e(trans('home.password')); ?></label>
                                    <input type="password" class="form-control" placeholder="<?php echo e(trans('home.password')); ?>" name="password" data-minlength="8">
                                    <p><code><?php echo e(trans('home.Your Password Must Be at Least 6 Characters')); ?></code></p>
                                </div>

                                <div class="form-group col-md-6">
                                    <label><?php echo e(trans('home.image')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <fieldset class="form-group">
                                        <label for="phone1"><?php echo e(trans('home.phone')); ?></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fas fa-phone"></i>
                                                </span>
                                            </div>
                                            <input type="number" min="0" class="form-control" placeholder="<?php echo e(trans('home.phone')); ?>" name="phone" autocomplete="off" required value="<?php echo e($user->phone); ?>">
                                        </div>
                                    </fieldset>
                                </div>

                                <?php if($user->image): ?>
                                    <div class="form-group col-md-12">                                        
                                    <label><?php echo e(trans('home.image')); ?></label><br>
                                        <img src="<?php echo e(url('\uploads\users\resize200')); ?>\<?php echo e($user->image); ?>" width="150">
                                    </div>
                                <?php endif; ?>

                                <div class="form-group col-md-6">
                                    <label for="helperText"><?php echo e(trans('home.roles')); ?></label>
                                    <select class="form-control role select2" name="role[]" multiple>
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($role->name); ?>" <?php if(in_array($role->name,$userRoles)): ?> selected <?php endif; ?>><?php echo e($role->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-md-6">            
                                    <label for="helperText"><?php echo e(trans('home.admin')); ?></label>
                                    <select class="form-control admin select2" name="admin">
                                        <option value="1" <?php if($user->is_admin == 1): ?> selected <?php endif; ?>><?php echo e(trans('home.yes')); ?></option>
                                        <option value="0" <?php if($user->is_admin == 0): ?> selected <?php endif; ?>><?php echo e(trans('home.no')); ?></option>
                                    </select>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/users')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('.role').select2({
            placeholder: 'Select Roles'
        });

        $('.admin').select2();

        $(".email").attr("autocomplete","off");
        
        $(".img").fileinput({showUpload:false, previewFileType:'any' ,theme: 'fa'});
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\opera\resources\views/admin/users/editUser.blade.php ENDPATH**/ ?>