<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Faq;
use \Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class FaqController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:faq');
    }

    public function editFaq()
    {
        $questions = Faq::where('type', 'general')->get();
        return view('admin.faqs.editFaq', compact('questions'));
    }

    public function store(Request $request)
    {
        $statuses = $request->status;
        $questions_en = $request->questions_en;
        $answers_en = $request->answers_en;
        $questions_ar = $request->questions_ar;
        $answers_ar = $request->answers_ar;
        $video_ids = $request->video_id;
        if ($questions_en) {
            foreach ($questions_en as $key => $question) {
                $faq = new Faq();
                $faq->type = 'general';
                $faq->question_en = $question;
                $faq->answer_en = $answers_en[$key];
                $faq->question_ar = $questions_ar[$key];
                $faq->answer_ar = $answers_ar[$key];
                $faq->status = $statuses[$key]??null;
                $faq->video_id = $video_ids[$key]?? null;
                $faq->save();
            }
        }

        return back()->with('success', trans('home.your_item_updated_successfully'));
    }

    public function updateGeneralFaq(Request $request)
    {
        $faq = Faq::find($request->faq_id);
        $faq->question_en = $request->questions_en;
        $faq->answer_en = $request->answers_en;
        $faq->question_ar = $request->questions_ar;
        $faq->answer_ar = $request->answers_ar;
        $faq->status = $request->status;
        $faq->video_id = $request->video_id;
        $faq->save();
        return back()->with('success', trans('home.faq_updated_successfully'));
    }

    public function removeGeneralFaq()
    {
        $faqId = $_POST['faq_id'];
        Faq::find($faqId)->delete();
    }
}
