<?php

namespace App\Http\Controllers;

use App\Models\Service;
use File;
use Image;
use Auth;
use App\Models\ServiceImage;
use DB;
use Illuminate\Http\Request;
use App\Models\Faq;
use App\Helpers\Helper;

class ServiceController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:service');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $services = Service::all();
        return view('admin.services.services',compact('services'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $services = Service::get();
        return view('admin.services.addService',compact('services'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $add = new Service();
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->pdf_ar = $request->pdf_ar;
        $add->pdf_en = $request->pdf_en;
        $add->order = $request->order;
        $add->link_en = str_replace(" ","-",$request->link_en);
        $add->link_ar = str_replace(" ","-",$request->link_ar);
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->alt_img = $request->alt_img;
        $add->youtube_link = $request->youtube_link ? $this->getYoutubeEmbedUrl($request->youtube_link) : '';
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_en =$request->meta_desc_en;
        $add->meta_desc_ar =$request->meta_desc_ar;
        $add->meta_robots =$request->meta_robots;
        $add->status = $request->status;
        $add->home = $request->home;
        $add->menu = $request->menu;
        $add->writer_id = $request->writer_id;
        $add->parent_id = $request->parent_id??0;

        if ($request->hasFile("img")) {

            $file = $request->file("img");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/services/source/' . $fileName);
            //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);


            $add->img = $fileName;
        }
         if ($request->file('file')) {
            $fileName = time() . '_' . $request->file('file')->getClientOriginalName();
        
            $folderPath = base_path('uploads/services/pdfs');  

            $file = $request->file('file')->move($folderPath, $fileName);  
    
            $add->file = $fileName;  
        }
        
          //////////// add faqs/////////////
        $questions=$request->question;
        $answers =$request->answer;
        $statuses =$request->faq_status;
        foreach($questions as $key=>$question){
            if($question){
                $faq=new Faq();
                $faq->blog_item_id=$blogitem->id;
                $faq->type='blog_item';
                $faq->question_en=$question;
                $faq->answer_en=$answers[$key];
                $faq->save();
            }}

        $add->save();


        return redirect('admin/services')->with('success',trans('home.your_item_added_successfully'));
    
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $service=Service::find($id);
        if($service){
            $questions = Faq::where('type','service')->where('service_id',$id)->get();
            $services = Service::get();

            $images = DB::table('temp_upload_files')->where('type','service')->where('service_id',$id)->get();
            if(count($images) > 0){
                foreach($images as $image){
                    try{
                        $img_path = base_path() . '/uploads/services/source/';
                        if($image->server_name){
                            file_exists($img_path.$image->server_name) ? unlink($img_path.$image->server_name):'';
                        }
                    }catch(Exception $e){
                    }
                }
                DB::table('temp_upload_files')->where('type','service')->where('service_id',$id)->delete();
                session()->forget('imagesUpload');
                session()->forget('imagesUploadRealName');
            }

            return view('admin.services.editService',compact('services','service','questions'));
        }else{
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        $add = Service::find($id);
        $add->name_en = $request->name_en;
        $add->name_ar = $request->name_ar;
        $add->order = $request->order;
        $add->link_en = str_replace(" ","-",$request->link_en);
        $add->link_ar = str_replace(" ","-",$request->link_ar);
        $add->text_en = $request->text_en;
        $add->text_ar = $request->text_ar;
        $add->alt_img = $request->alt_img;
        $add->youtube_link = $request->youtube_link ? $this->getYoutubeEmbedUrl($request->youtube_link) : '';
        $add->meta_title_en = $request->meta_title_en;
        $add->meta_title_ar = $request->meta_title_ar;
        $add->meta_desc_en =$request->meta_desc_en;
        $add->meta_desc_ar =$request->meta_desc_ar;
        $add->meta_robots =$request->meta_robots;
        $add->status = $request->status;
        $add->home = $request->home;
        $add->menu = $request->menu;
        $add->writer_id = $request->writer_id;
        $add->parent_id = $request->parent_id??0;

        if ($request->hasFile("img")) {

            $file = $request->file("img");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/services/source/';

            if ($add->img != null) {
                file_exists($img_path.$add->img) ?  unlink(sprintf($img_path . '%s', $add->img)):'';
            }

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/services/source/' . $fileName);
            //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);

            $add->img = $fileName;
        }

        if ($request->hasFile("icon")) {

            $file = $request->file("icon");
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            $img_path = base_path() . '/uploads/services/source/';

            if ($add->icon != null) {
                file_exists($img_path.$add->icon) ? unlink($img_path.$add->icon):'';
            }

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image
            $path = base_path('uploads/services/source/' . $fileName);
            $resize200 = base_path('uploads/services/resize200/' . $fileName);
            $resize800 = base_path('uploads/services/resize800/' . $fileName);
            //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);

            $add->icon = $fileName;
        }
          if ($request->file('file')) {
            $folderPath = base_path('uploads/services/pdfs');
            //remove old pdf file
             if ($add->file && file_exists($folderPath . '/' . $add->file)) {
                unlink($folderPath . '/' . $add->file);
            }
            //add new pdf file
            $fileName = time() . '_' . $request->file('file')->getClientOriginalName();
            $file = $request->file('file')->move($folderPath, $fileName);  
            $add->file = $fileName;  
            }

        $add->save();


        //////////// add faqs/////////////
        $questions=$request->question;
        $answers =$request->answer;
        $statuses =$request->faq_status;
        if($questions){
            foreach($questions as $key=>$question){
                if($question){
                    $faq=new Faq();
                    $faq->service_id=$add->id;
                    $faq->type='service';
                    $faq->question_en=$question;
                    $faq->answer_en=$answers[$key];
                    $faq->save();
                }
            }
        }

        ///////// save project images//////
        if(\Session::has('imagesUpload')){
//            $images = \Session::get('imagesUpload');
            $images = DB::table('temp_upload_files')->where('service_id',$id)->get();
            foreach ($images as $key=>$file) {
                $img = new ServiceImage();
                $img->image = $file->server_name;
                $img->service_id=$add->id;
                $img->save();
            }
        }

        DB::table('temp_upload_files')->where('service_id',$id)->delete();
        session()->forget('imagesUpload');
        session()->forget('imagesUploadRealName');
        return redirect('admin/services')->with('success',trans('home.your_item_added_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($ids)
    {
        //
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            $service = Service::findOrFail($id);
            $img_path = base_path() . '/uploads/services/source/';

            if ($service->img != null) {
                file_exists($img_path.$service->img) ? unlink($img_path.$service->img):'';

            }

            if ($service->icon != null) {
                file_exists($img_path.$service->icon) ? unlink($img_path.$service->icon):'';
            }

            $service->delete();
        }
    }


        /////// upload product images///////////////
    public function uploadImages(Request $request){
        if($request->hasFile('file')){

            $file = $request->file("file");
            $realName = $file->getClientOriginalName();
            $mime = File::mimeType($file);
            $mimearr = explode('/', $mime);

            // $destinationPath = base_path() . '/uploads/'; // upload path
            $extension = $mimearr[1]; // getting file extension
            $fileName = rand(11111111, 99999999) . '.' . $extension; // renameing image

            $path = base_path('uploads/services/source/' . $fileName);

            //  $file->move($destinationPath, $fileName);

            Image::make($file->getRealPath())->save($path);

            DB::table('temp_upload_files')->insert(['server_name' => $fileName,'original_name' => $realName ,'service_id' => $request->serviceId, 'type'=>'service']);
            if(\Session::has('imagesUpload')){
                \Session::push('imagesUpload',$fileName);
                \Session::push('imagesUploadRealName',$realName);
            }else{
                $images = [];
                array_push($images,$fileName);
                \Session::put('imagesUpload',$images);

                $realImages = [];
                array_push($realImages,$realName);
                \Session::put('imagesUploadRealName',$realImages);
            }
        }
    }

    ///////// delete uploaded images///////////
    public function removeUploadImages(Request $request)
    {
        $name = $request->name;
        $names = \Session::get('imagesUploadRealName');
        $images = \Session::get('imagesUpload');
        $key = array_search($name, $names);

        $img_path = base_path() . '/uploads/services/source/';

        unlink(sprintf($img_path . '%s', $images[$key]));

        unset($images[$key]);
        unset($names[$key]);
        \Session::put('imagesUpload',$images);
        \Session::put('imagesUploadRealName',$names);
        DB::table('temp_upload_files')->where('original_name',$name)->delete();
    }

    public function deleteImege(){
        $serviceId = $_POST['serviceId'];
        $image = $_POST['image'];
        $img =ServiceImage::where('service_id',$serviceId)->where('id',$image)->first();

        $img_path = base_path() . '/uploads/services/source/';

        if ($img->image != null) {
            file_exists($img_path.$img->image) ? unlink($img_path.$img->image):'';

        }
        $img->delete();
    }

    function getYoutubeEmbedUrl($url){
         $shortUrlRegex = '/youtu.be\/([a-zA-Z0-9_-]+)\??/i';
         $longUrlRegex = '/youtube.com\/((?:embed)|(?:watch))((?:\?v\=)|(?:\/))([a-zA-Z0-9_-]+)/i';

        if (preg_match($longUrlRegex, $url, $matches)) {
            $youtube_id = $matches[count($matches) - 1];
        }

        if (preg_match($shortUrlRegex, $url, $matches)) {
            $youtube_id = $matches[count($matches) - 1];
        }
        return 'https://www.youtube.com/embed/' . $youtube_id ;
    }

    public function copy(){
        $ids= $_POST['ids'];
        $img_path = base_path() . '/uploads/services/source/';
        foreach ($ids as $index=>$id) {
            $old_service = Service::findOrFail($id);
            $new_service = new Service();
            $new_service->name_en = $old_service->name_en;
            $new_service->name_ar = $old_service->name_ar;
            $add->pdf_ar = $request->pdf_ar;
            $add->pdf_en = $request->pdf_en;
            $new_service->order = $old_service->order;
            $new_service->link_en = $old_service->link_en?preg_replace("/[ \/]/", "-", $old_service->link_en):preg_replace("/[ \/]/", "-", $old_service->title_en).'-'.$index;
            $new_service->link_ar = $old_service->link_ar?preg_replace("/[ \/]/", "-", $old_service->link_ar):preg_replace("/[ \/]/", "-", $old_service->title_ar).'-'.$index;
            $new_service->alt_img = $old_service->alt_img;
            $new_service->status = $old_service->status;
            $new_service->home = $old_service->home;
            $new_service->text_en = $old_service->text_en;
            $new_service->text_ar = $old_service->text_ar;
            $new_service->youtube_link = $old_service->youtube_link;
            $new_service->meta_title_en = $old_service->meta_title_en;
            $new_service->meta_title_ar = $old_service->meta_title_ar;
            $new_service->meta_desc_en =$old_service->meta_desc_en;
            $new_service->meta_desc_ar =$old_service->meta_desc_ar;
            $new_service->meta_robots =$old_service->meta_robots;
            $new_service->parent_id = $old_service->parent_id;

            if ($old_service->icon != null) {
                $new_image_path = $img_path . 'service_'.$index.'_' . $old_service->icon;
                if (file_exists($img_path . $old_service->icon)) {
                    copy($img_path . $old_service->icon, $new_image_path);
                }
                $new_service->icon = 'service_'.$index.'_'.$old_service->icon;
            }
            if ($old_service->img != null) {
                $new_image_path = $img_path . 'service_'.$index.'_' . $old_service->img;
                if (file_exists($img_path . $old_service->img)) {
                    copy($img_path . $old_service->img, $new_image_path);
                }
                $new_service->img = 'service_'.$index.'_'.$old_service->img;

            }

            $new_service->save();

        }
    }

    public function deleteAllIMages(){
        $service_id = $_POST['id'];
        $imgs =ServiceImage::where('service_id',$service_id)->get();

        $img_path = base_path() . '/uploads/services/source/';
        foreach($imgs as $img){
            if ($img->image != null) {
                file_exists($img_path.$img->image) ? unlink($img_path . $img->image):'';
            }
            $img->delete();
        }
    }
    
    public function deleteFile(Service $service)
{
 
 try {
        if (!$service->file) {
            return response()->json(['success' => false, 'message' => 'No file associated with this project.']);
        }

        $filepath = Helper::uploadedFilesPath('services', $service->file);
        
        if (file_exists($filepath)) {
            unlink($filepath);
        }

        $service->file = null;
        $service->save();

        return response()->json(['success' => true, 'message' => 'File deleted successfully.']);
    } catch (\Exception $e) {
        
        return response()->json([
            'success' => false,
            'message' => 'An error occurred while deleting the file.',
            'error' => $e->getMessage()
        ], 500);
    }
}
    
     public function updateFaq(Request $request){
        $faq=Faq::find($request->faq_id);
        $faq->question_en = $request->question;
        $faq->answer_en = $request->answer;
        // $faq->statue = $request->statue;
        $faq->save();
        return back()->with('success',trans('home.faq_updated_successfully'));

    }
    
    public function removeFaq(){
        $faqId= $_POST['faq_id'];
        Faq::find($faqId)->delete();
    }


}
