@extends('layouts.admin')

@section('meta')

<title>{{__('home.footer')}} </title>

@endsection

@section('content')

<div class="container-fluid">

    <p>this is footer page with url :{{Request::url()}} </p>

    <div class="row">

        <div class="col-12">

            <div class="page-title-box d-sm-flex align-items-center justify-content-between">

                <h4 class="mb-sm-0 font-size-18">{{trans('home.footer')}}</h4>



                <div class="page-title-right">

                    <ol class="breadcrumb m-0">

                        <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>

                        <li class="breadcrumb-item"><a href="{{url('/admin/home-sliders')}}">{{trans('home.footer')}}</a></li>

                        <li class="breadcrumb-item active">{{trans('home.addfooter')}}</li>

                    </ol>

                </div>



            </div>

        </div>

    </div>

{{-- Row --}}

<div class="row">

    <div class="col-lg-12">

        <div class="card">

            <div class="card-header">

                <h4 class="card-title">{{trans('home.footer')}}</h4>

            </div>

            <div class="card-body p-4">

                <div class="row">

                    <div class="col-lg-12">

{{-- Fill the form of Footer --}}

                <form action="{{route('footer')}}" method="POST" enctype="multipart/form-data">

                    <input type="hidden" name="_token" value="{{ csrf_token() }}">

                    {{-- @csrf --}}

                    <div class="row">

                    <div class="col-md-6 mb-3">

                        <label class="">{{__('home.title')}}</label>

                        <input class="form-control"  type="text" placeholder="{{__('home.title')}}" name="title" > 

                    </div>   



                    <!--<div class="col-md-6 mb-3">-->

                    <!--    <label for="helperText">{{trans('home.lang')}}</label>-->

                    <!--    <select class="form-control" data-trigger name="lang" required>-->

                    <!--        <option value="en">{{trans('home.english')}}</option>-->

                    <!--        <option value="ar">{{trans('home.arabic')}}</option>-->

                    <!--    </select>-->

                    <!--</div>-->

                </div>

                    <div class="col-md-6 mb-3">

                        <label class="">{{trans('home.link_en')}}</label>

                        <div class="input-group">

                            <div class="input-group-prepend">

                                <span class="input-group-text">http://www.google.com</span>

                            </div>

                            <input type="text" class="form-control"  placeholder="{{trans('home.link_en')}}" name="link_en" >

                        </div> 

                    </div>

                    <div class="col-md-6 mb-3">

                        <label class="">{{trans('home.link_ar')}}</label>

                        <div class="input-group">

                            <div class="input-group-prepend">

                                <span class="input-group-text">http://www.google.com</span>

                            </div>

                            <input type="text" class="form-control"  placeholder="{{trans('home.link_ar')}}" name="link_ar" >

                        </div> 

                    </div>

                    <div class="row">

                        <div class="col-md-6 mb-3 ">

                            <label for="text_en">{{trans('home.text_en')}}</label>

                            <textarea class="form-control ckeditor-classic"  placeholder="{{trans('home.text_en')}}"  name="text_en"></textarea>

                        </div>



                        <div class="col-md-6 mb-3 ">

                            <label for="text_ar">{{trans('home.text_ar')}}</label>

                            <textarea class="form-control ckeditor-classic"  placeholder="{{trans('home.text_ar')}}"  name="text_ar"></textarea>

                        </div>

                    </div>

                    <div class="row">

                        <div class="col-md-6 mb-3">

                            <label class="">{{__('home.address_en')}}</label>

                            <input type="text" class="form-control"   placeholder="{{__('home.address_en')}}" name="address_en" > 

                        </div>   



                        <div class="col-md-6 mb-3">

                            <label class="">{{__('home.address_ar')}}</label>

                            <input  type="text" class="form-control"   placeholder="{{__('home.address_ar')}}" name="address_ar" > 

                        </div>   

                    </div>

                    <div class="row">

                        <div class="col-md-6 mb-3">

                            <label for="formFile" class="form-label">{{ __('home.choose_logo') }}</label>

                            <input  type="file" class="form-control"  id="formFile" name="image">

                        </div>

                        <div class="col-md-6 mb-3">

                            <label class="">{{__('home.number_phone')}}</label>

                            <input type="text" class="form-control"  placeholder="{{__('home.number_phone')}}" name="phone" > 

                        </div> 

                      

                    </div>

                    <div class="row">

                        <div class="col-md-6 mb-3">

                            <label class="">{{__('home.Copyright_en')}}</label>

                            <input type="text" class="form-control"   placeholder="{{__('home.Copyright_en')}}" name="copyright_en" > 

                        </div>   



                        <div class="col-md-6 mb-3">

                            <label class="">{{__('home.Copyright_ar')}}</label>

                            <input type="text" class="form-control"   placeholder="{{__('home.Copyright_ar')}}" name="copyright_ar" > 

                        </div>   

                        <div class="form-check d-flex">

                            <input type="checkbox" value="1" id="switch" switch="success"  name="published" />

                            <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>

                            <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>

                        </div>



                        <div class="mt-4">

                            <button type="submit" class="btn btn-primary w-md">{{trans('home.save')}}</button>

                            <a href="{{url('/admin/dashboard')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>

                        </div>

                </form>

                    </div>

                </div>

            </div>





        </div>

    </div>

</div>



</div>

@endsection