
<section class="request-section pb-90 overflow-hidden">
    <div class="container">
        <div class="row request-wrap">
            <div class="col-lg-7">
                <div class="request-img">
                    <div class="shape"><img src="{{ asset('resources/assets/front/img/shapes/req-shape.png') }}"
                            alt="shape"></div>
                    <img src="{{ asset('resources/assets/front/img/bg-img/cta-bg.png') }}" alt="img">
                </div>
            </div>
            <div class="col-lg-5">
                <div class="request-content pt-120">
                    <div class="section-heading mb-30">
                        <h4 class="sub-heading"><span>//</span>{{ __('home.ContactWithUs') }}</h4>
                        <h2 class="section-title">{{ __('home.Join the Community') }}<br>
                            <span>{{ __('home.to Know Us') }} </span></h2>
                    </div>
                </div>
            </div>
            <div class="request-form-wrap"
                data-background="{{ asset('resources/assets/front/img/bg-img/request-bg.png') }}">
                <div id="success-message" style="color: green;"></div>
                <form action="{{ route('contact.save') }}" method="POST" id="ajax-contact" class="ajax-submit"
                    novalidate>
                    @csrf
                    <div class="request-form">
                        <div class="form-group row">
                            <div class="col-md-12">
                                <div class="form-item">
                                    <input type="text" id="fullname" name="name" class="form-control"
                                        placeholder="{{ __('home.entername') }}">
                                    <div class="alert alert-danger print-error-msg" id="error-name"
                                        style="display:none; color: red;">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-item">
                                    <input type="text" id="email-2" name="email" class="form-control"
                                        placeholder="{{ __('home.entername') }}">
                                    <div class="alert alert-danger print-error-msg" id="error-email"
                                        style="display:none; color: red;">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-item">
                                    <input type="phone" class="form-control" name="phone"
                                        placeholder="{{ __('home.phone') }}">
                                    <div class="alert alert-danger print-error-msg" id="error-phone"
                                        style="display:none; color: red;">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-item">
                                    <input class="form-control"
                                          type="datetime-local"
                                          id="meeting-time"
                                          name="meeting-time"
                                          value="2018-06-12T19:30"
                                          min="2024-12-07T00:00"
                                          max="2025-06-14T00:00" />     
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-item">
                                    <input type="text" id="subject" name="status" class="form-control"
                                        placeholder="{{__('home.status')}}">  
                                        <div class="alert alert-danger print-error-msg" id="error-status"
                                        style="display:none; color: red;">
                                    </div>                
                                </div>
                                
                            </div>
                        </div>


                        <div class="form-group row">
                            <div class="col-md-12">
                                <div class="form-item message-item">
                                    <textarea id="message" name="message" cols="30" rows="5" class="form-control address"
                                        placeholder="{{ __('home.message') }}"></textarea>
                                    <div class="alert alert-danger print-error-msg" id="error-message"
                                        style="display:none; color: red;">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="submit-btn">
                            <button id="submit" type="button" class="bd-primary-btn">{{ __('home.book_now') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="maps row mt-5">
            @foreach ($addresses as $index => $address)
                @if ($index < 2)
                    <div class="col-sm-12 col-md-6 col-lg-6">
                        <div class="map">
                            <h3 class="mb-2"> {{$address->{'address_'.$lang} }} </h3>
                            <iframe
                                src="https://www.google.com/maps?q={{ urlencode($address->address_en) }}&output=embed"
                                width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"></iframe>
                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    </div>
</section>
<!-- ./ blog-section -->
@section('script')
    <script>
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $('#submit').on('click', function() {
            submitForm(); // Call the function to submit the form via AJAX
        });

        function submitForm() {
            $('.print-error-msg').hide().text('');
            // $('.print-error-msg ul').html('');
            $('#success-message').text('');
            const url = $('#ajax-contact').attr('action');
            let formData = new FormData($('#ajax-contact')[0]);

            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: (response) => {
                    console.log('Success:', response);
                    $('#success-message').text(response);
                    $('#ajax-contact')[0].reset();
                },
                error: (response) => {
                    console.log('Error:', response);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        }

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                if (errorElement.length) {
                    errorElement.show().text(messages[0]);
                }
            });
        }
    </script>
@endsection
