    <title><?php echo e(trans('home.projects')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.projects')); ?></h4>
    
                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo e(trans('home.projects')); ?></li>
                        </ol>
                    </div>
    
                </div>
            </div>
        </div>
        <a href="<?php echo e(url('admin/projects/create')); ?>"><button class="btn ripple btn-primary col-md-2"><i class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
        <a href="javascript:void(0)"><button class="copyButton btn ripple btn-info col-md-2"><i class="bx bx-copy-alt"></i> <?php echo e(trans('home.copy')); ?></button></a>
        <!-- End Page Header -->
    
        <?php if(session()->has('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session()->pull('success')); ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        <div class="container-fluid">
            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card-body">
                        <table id="datatable" class="table table-striped text-center">
                            <thead>
                                <tr>
                                    <th class="sorting sorting_asc"><input type="checkbox" id="checkAll"/></th>
                                    <th class="sorting"><?php echo e(trans('home.id')); ?></th>
                                    <th class="sorting"><?php echo e(trans('home.name_en')); ?></th>
                                    <th class="sorting"><?php echo e(trans('home.name_ar')); ?></th>
                                    <th class="sorting"><?php echo e(trans('home.image')); ?></th>
                                    <th class="sorting"><?php echo e(__('home.publish/unpublish')); ?></th>
                                    <th class="sorting"><?php echo e(__('home.edit')); ?></th>
                                    <th class="sorting"><?php echo e(__('home.delete')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($project->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked " value="<?php echo e($project->id); ?>" /> </td>
                                        <td><a href="<?php echo e(route('projects.edit', $project->id)); ?>"><?php echo e($project->id); ?></a></td>
                                        <td><?php echo e($project->name_en); ?></td>
                                        <td><?php echo e($project->name_ar); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('projects.edit', $project->id)); ?>">
                                                <?php if($project->image): ?>
                                                    <img style="height: 150px;object-fit: contain" src="<?php echo e(url('/uploads/projects/source')); ?>/<?php echo e($project->image); ?>" width="150">
                                                <?php else: ?>
                                                    <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="150">
                                                <?php endif; ?>
                                            </a>
                                        </td>
                                        <td> 
                                            <input class="btn_active" data-id="<?php echo e($project->id); ?>" type="checkbox" id="switch-<?php echo e($project->id); ?>" switch="success" <?php echo e($project->status == 1?'checked':''); ?> />
                                                <label for="switch-<?php echo e($project->id); ?>" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                        </td>
                                        <td> 
                                            <a type="button" class="btn btn-info waves-effect waves-light " 
                                                href="<?php echo e(route('projects.edit',$project->id)); ?>" ><?php echo e(__('home.edit')); ?></a>
                                        </td>
                                        <td> 
                                            <a type="button" class="btn btn-danger waves-effect waves-light btn_delete " 
                                                data-id="<?php echo e($project->id); ?>"><?php echo e(__('home.delete')); ?></a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).on('click', '.copyButton', function() {
            var ids = [];
            $('.tableChecked:checked').each(function(i){
                ids[i] = $(this).val();
            });
            if(ids.length === 0) //tell you if the array is empty
            {
                alert("Please Select atleast one checkbox");
            }
            else{
              
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"<?php echo route('ProjectsCopy') ?>",
                    type:'POST',
                    data:{ids:ids},
                    success:function(data)
                    {
                        // console.log(data);
                        location.reload();
                    }
                });
            }

        });
    </script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\projectbegroup\resources\views/admin/projects/projects.blade.php ENDPATH**/ ?>