<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_address')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.addresses')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/addresses')); ?>"><?php echo e(trans('home.addresses')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_address')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(trans('home.edit_address')); ?></h4>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php echo Form::open(['method'=>'PATCH','url' => 'admin/addresses/'.$address->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <div class="row">

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.title_en')); ?></label>
                                        <input class="form-control" name="title_en" type="text" placeholder="<?php echo e(trans('home.title_en')); ?>"  value="<?php echo e($address->title_en); ?>">
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.title_ar')); ?></label>
                                        <input class="form-control" name="title_ar" type="text" placeholder="<?php echo e(trans('home.title_ar')); ?>" value="<?php echo e($address->title_ar); ?>" >
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.address_en')); ?></label>
                                        <input class="form-control" name="address_en" type="text" placeholder="<?php echo e(trans('home.address_en')); ?>"  value="<?php echo e($address->address_en); ?>">
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.address_ar')); ?></label>
                                        <input class="form-control" name="address_ar" type="text" placeholder="<?php echo e(trans('home.address_ar')); ?>" value="<?php echo e($address->address_ar); ?>" >
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label><?php echo e(trans('home.phone')); ?></label>
                                        <input class="form-control" name="tel" type="tel" placeholder="<?php echo e(trans('home.phone')); ?>" value="<?php echo e($address->tel); ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.email')); ?></label>
                                        <input class="form-control" name="email" type="email" placeholder="<?php echo e(trans('home.email')); ?>" value="<?php echo e($address->email); ?>" >
                                    </div>

                                    <div class="col-md-12">
                                        <label><?php echo e(trans('home.map_url')); ?></label>
                                        <textarea class="form-control" name="map_url" type="text" placeholder="<?php echo e(trans('home.map_url')); ?>"><?php echo e($address->map_url); ?></textarea>
                                    </div>

                                    <div class="col-md-4 mb-3">
                                        <label for="parent"><?php echo e(trans('home.type')); ?></label>
                                        <select class="form-control" data-trigger name="type">
                                            <option value="Office" <?php echo e($address->type=='Office'?'selected':''); ?> >Office</option>
                                            <option value="Studio" <?php echo e($address->type=='Studio'?'selected':''); ?> >Studio</option>
                                            <option value="Shop" <?php echo e($address->type=='Shop'?'selected':''); ?> >Shop</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-2 mb-3">                                    
                                        <div class="form-check d-flex">
                                            <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e(($address->status == 1)? 'checked':''); ?> />
                                            <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                            <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                        </div>
                                    </div> 
                                </div> 
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-xl"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/addresses')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/prekers/resources/views/admin/addresses/editAddress.blade.php ENDPATH**/ ?>