@php
    $footerTitles = $titles->filter(fn($title) => $title->type === 'footer');
@endphp
<!--====================Site Footer==============-->
@foreach ($footerTitles as $title)
<footer class="footer  bg-img bg-fixed" data-background="{{url('uploads/titles/source/' , $title->image) }}" data-overlay-dark="6">
    <div class="top">
        <div class="container">
            <div class="row">
                <div class="col-md-4 col-lg-3 col-12 mb-30">
                    <div class="item text-center">
                    <img class="footer-logo" src="{{ url('uploads/settings/source/' . $configration->footer_logo) }}" alt="footer_logo">
                    <div class="social text-center mt-2">
                        @if($setting->twitter)
                        <a href="{{$setting->twitter}}"><i class="ti-twitter"></i></a>
                        @endif
                        @if($setting->instgram)
                        <a href="{{$setting->instgram}}"><i class="ti-instagram"></i></a>
                        @endif
                        @if($setting->linkedin)
                        <a href="{{$setting->linkedin}}"><i class="ti-linkedin"></i></a>
                        @endif
                        @if($setting->facebook)
                        <a href="{{$setting->facebook}}"><i class="ti-facebook"></i></a>
                        @endif
                        @if($setting->youtube)
                        <a href="{{$setting->youtube}}"><i class="ti-youtube"></i></a>
                        @endif
                    </div>
                </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="item">
                        <h3>{{ trans('home.quick_links') }} <span></span></h3>
                        <ul>
                            <li><a href="{{LaravelLocalization::LocalizeUrl('/') }}">{{ trans('home.home') }}</a></li>
                            <li><a href="{{LaravelLocalization::LocalizeUrl('about-us') }}">{{ trans('home.about_us') }}</a></li>
                            <li><a href="{{LaravelLocalization::LocalizeUrl('blogs') }}">{{ trans('home.blogs') }}</a></li>
                            <li><a href="{{LaravelLocalization::LocalizeUrl('contact-us') }}">{{ trans('home.contact-us') }}</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="item">
                        <h3>{{ trans('home.products') }} <span></span></h3>
                        <ul>
                            @foreach($menuServices as $menuService)
                            <li><a href="{{LaravelLocalization::LocalizeUrl('service/' .$menuService->{'link_' .$lang}) }}">{{$menuService->{'name_' .$lang} }}</a></li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-md-4 col-lg-3 col-12">
                    <div class="item">
                        <h3>{{ trans('home.contactinfo') }} <span></span></h3>
                        @foreach($addresses as $address)
                        <p>{{$address->{'address_' .$lang} }}
                            <br>{{$address->{'title_' .$lang} }}
                        </p>
                        @endforeach
                        @foreach($phones as $phone)
                        <p class="phone"><a href="tel:{{$phone->code}}{{$phone->phone}}">{{$phone->phone}}</a></p>
                        @endforeach
                        <a href="mailto:{{$setting->email}}"><p class="mail">{{$setting->email}}</p></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="bottom">
        <div class="container">
            <div class="row">
                <div class="col-md-12 col-12">
                    <p>© All Rights Reserved TrustOffice, Developed and Designed by <a href=""> BeGroup </a>| 2024</p>
                </div>
            </div>
        </div>
    </div>
</footer>
<!--====================Gallery==============-->
@endforeach
