{{-- @extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
@endsection

@section('content')
    @if (count($projects) > 0)
        <!-- content-->
        <div class="content" data-pagetitle="{{ trans('home.projects') }}">
            <!-- ========== Start Top Parg Normal ========== -->
            <section id="top-p">
                <div class="container">
                    <h2>{{ trans('home.projects') }}</h2>
                    {!! $configration->about_app !!}
                    <div class="row">
                        <div class="col-lg-12 content-area">
                            <div class="btns">
                                <div class="Call-btn">
                                    <a href="tel:+2{{ $setting->mobile }}" class="fixed-phone"
                                        target="_blank">{{ trans('home.call') }}<i class="fa fa-phone"></i> </a>
                                </div>
                                <div class=" Whatsapp-btn">
                                    <a href="https://wa.me/+2{{ $setting->whatsapp }}" class="fixed-whatsapp"
                                        target="_blank">{{ trans('home.whatsapp') }}<i class="fab fa-whatsapp"></i> </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- ========== End Top Parg Normal ========== -->
            <!-- ========== Start Gallery Normal ========== -->
            <section class="gallery-page mb-90 inside" id="rs-projects">
                <div class="container">
                    <div class="row">
                        @foreach ($projects as $key => $project)
                            <!--Gallery Page Single Start-->
                            <div class="col-xl-4 col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="200ms">
                                <div class="gallery-page__single">
                                    <div class="gallery-page__img">
                                        <img src="{{ Helper::uploadedImagesPath('projects', $project->image) }}"
                                            alt="">
                                        <div class="gallery-page__icon">
                                            <a data-fancybox="{{ $key }}"
                                                href="{{ Helper::uploadedImagesPath('projects', $project->image) }}">
                                                <span class="fa fa-expand"></span></a>
                                        </div>

                                        <div style="display:none">
                                            @foreach ($project->images() as $index => $projectImage)
                                                <a data-fancybox="{{ $key }}"
                                                    href="{{ Helper::uploadedImagesPath('projects', $projectImage->image) }}">
                                                    <img
                                                        src="{{ Helper::uploadedImagesPath('projects', $projectImage->image) }}" />
                                                </a>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="gallery-text">
                                        <h4 class="pt-10">
                                            {{ app()->getLocale() == 'en' ? $project->name_en : $project->name_ar }}</h4>
                                    </div>
                                </div>
                            </div>
                            <!--Gallery Page Single End-->
                        @endforeach
                    </div>
                </div>
            </section>
            <!--Gallery Page End-->
            <section class="projects-rev">
                <div class="container">
                    <div class="row">
                        <div class="col-sm-12 col-md-8 m-auto">
                            <div id="respond" class="clearafix">
                                <div class="pr-subtitle">{{ trans('home.contact-us') }}</div>
                                <div class="section-separator fl-wrap sp2"><span></span></div>
                                <div class="comment-reply-form clearfix">
                                    <form id="add-comment" class="add-comment custom-form" method="POST"
                                        action="{{ LaravelLocalization::localizeUrl('save/contact-us') }}">
                                        <fieldset>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <input type="text" placeholder="{{ trans('home.name') }} *"
                                                        value="name" />
                                                </div>
                                                <div class="col-md-6">
                                                    <input type="text" placeholder="{{ trans('home.email') }}*"
                                                        value="email" />
                                                </div>
                                                <div class="col-md-6">
                                                    <input type="number" placeholder="{{ trans('home.phone') }}*"
                                                        value="phone" />
                                                </div>
                                            </div>
                                            <textarea cols="40" rows="3" placeholder="{{ trans('home.message') }}:"></textarea>
                                        </fieldset>
                                        <button
                                            class="btn flat-btn color-bg"><span>{{ trans('home.send') }}</span></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--column-wrap end-->
            <div class="to-top-btn to-top"><i class="fal fa-long-arrow-up"></i></div>
        </div>
        <!-- content end-->
    @endif
@endsection
@section('script')
    @foreach ($projects as $key => $project)
        <script>
            Fancybox.bind('[data-fancybox="{{ $key }}"]', {
                Thumbs: {
                    type: "modern"
                }
            });
        </script>
    @endforeach
@endsection --}}
