<!-- Contact -->
<div class="contact section-padding">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <!-- Contact Info -->
                @foreach ($addresses as $address)
                    <h4 class="mb-4"><span>{{ $address->{'title_' . $lang} }}</span></h4>
                    <a href="{{ $address->map_url }}" target="_blank">
                        <p>{{ $address->{'address_' . $lang} }}</p>
                    </a>
                @endforeach
                @foreach ($phones as $phone)
                    <div class="phone"><a href="tel:{{ $phone->code }}{{ $phone->phone }}">{{ $phone->phone }}</a></div>
                @endforeach
                <div class="mail mb-3"><a href="mailto:{{ $setting->email }}">{{ $setting->email }}</a></div>
                <div class="social mt-2">
                    @if ($setting->twitter)
                        <a href="{{ $setting->twitter }}"><i class="ti-twitter"></i></a>
                    @endif
                    @if ($setting->instgram)
                        <a href="{{ $setting->instgram }}"><i class="ti-instagram"></i></a>
                    @endif
                    @if ($setting->facebook)
                        <a href="{{ $setting->facebook }}"><i class="ti-facebook"></i></a>
                    @endif
                    @if ($setting->youtube)
                        <a href="{{ $setting->youtube }}"><i class="ti-youtube"></i></a>
                    @endif
                    @if ($setting->linkedin)
                        <a href="{{ $setting->linkedin }}"><i class="ti-linkedin"></i></a>
                    @endif
                    @if ($setting->tiktok)
                        <a href="{{ $setting->tiktok }}"><i class="ti-tiktok"></i></a>
                    @endif
                </div>
            </div>
            <!-- form -->
            <div class="col-md-8">
                <h4 class="mb-4">{{ trans('home.contact_us') }}</span></h4>
                <form method="post" class="contact__form"
                    action="{{ LaravelLocalization::LocalizeUrl('save/contact-us') }}">
                    @csrf
                    <!-- Form message -->
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-success contact__msg" style="display: none" role="alert"> Your
                                message was sent successfully. </div>
                        </div>
                    </div>
                    <!-- Form elements -->
                    <div class="row">
                        <div class="col-md-12 form-group">
                            <input name="name" type="text" placeholder="{{ __('home.name') }} *" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <input name="email" type="email" placeholder="{{ __('home.email') }} *">
                        </div>
                        <div class="col-md-12 form-group">
                            <input name="phone" type="number" placeholder="{{ __('home.phone') }} *" required>
                        </div>
                        <div class="col-md-12 form-group">
                            <textarea name="message" id="message" cols="30" rows="4" placeholder="{{ __('home.message') }} *"></textarea>
                        </div>
                        <div class="col-md-12 mt-2">
                            <input name="submit" type="submit" value="{{ __('home.send') }}">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Maps -->
<div class="google-maps">
    <iframe src="{{ $setting->map_url }}" style="border:0;" allowfullscreen="" loading="lazy"
        referrerpolicy="no-referrer-when-downgrade"></iframe>
</div>
