<title><?php echo e(trans('home.add_slider')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.home_sliders')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/home-sliders')); ?>"><?php echo e(trans('home.home_sliders')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.add_slider')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- Row-->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(trans('home.add_slider')); ?></h4>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <!-- End Page Header -->
                            <?php echo Form::open(['route' => 'home-sliders.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <div class="row">

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.title')); ?></label>
                                        <input class="form-control" name="title" type="text" placeholder="<?php echo e(trans('home.title')); ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.title1')); ?></label>
                                        <input class="form-control" name="title1" type="text" placeholder="<?php echo e(trans('home.title1')); ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="helperText"><?php echo e(trans('home.lang')); ?></label>
                                        <select class="form-control" data-trigger name="lang" required>
                                            <option value="en"><?php echo e(trans('home.english')); ?></option>
                                            <option value="ar"><?php echo e(trans('home.arabic')); ?></option>
                                        </select>
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.order')); ?></label>
                                        <input class="form-control" name="order" type="number" min="0" autocomplete="off" placeholder="<?php echo e(trans('home.order')); ?>">
                                    </div>

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.link')); ?></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">http://www.google.com</span>
                                            </div>
                                            <input type="text" class="form-control" name="link" placeholder="<?php echo e(trans('home.link')); ?>" >
                                        </div> 
                                    </div>

                                    <div class="form-group col-md-12">
                                        <label class=""><?php echo e(trans('home.text')); ?></label>
                                        <textarea class="form-control ckeditor-classic"   name="text"  placeholder="<?php echo e(trans('home.text')); ?>"></textarea>
                                    </div>    
                                    
                                    <div class="col-md-12 mb-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="image">
                                    </div>
                                </div>
                                <div class="form-group">
                                    
                                    <div class="form-check d-flex">
                                        <input type="checkbox" value="1" name="status" id="switch" switch="success" checked />
                                        <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                        <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/home-sliders')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

</div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\fadali\resources\views/admin/sliders/home-sliders/addSlider.blade.php ENDPATH**/ ?>